/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class UptimeMetrics
implements MeterBinder {
    private final RuntimeMXBean runtimeMXBean;
    private final Iterable<Tag> tags;

    public UptimeMetrics() {
        this(Collections.emptyList());
    }

    public UptimeMetrics(Iterable<Tag> tags) {
        this(ManagementFactory.getRuntimeMXBean(), tags);
    }

    UptimeMetrics(RuntimeMXBean runtimeMXBean, Iterable<Tag> tags) {
        this.runtimeMXBean = Objects.requireNonNull(runtimeMXBean);
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        registry.more().timeGauge(registry.createId("uptime", this.tags, "The uptime of the Java virtual machine"), this.runtimeMXBean, TimeUnit.MILLISECONDS, x -> Long.valueOf(x.getUptime()).doubleValue());
    }
}

