/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.noop.NoopCounter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

class CompositeCounter
extends AbstractMeter
implements Counter,
CompositeMeter {
    private final Map<MeterRegistry, Counter> counters = Collections.synchronizedMap(new LinkedHashMap());

    CompositeCounter(Meter.Id id) {
        super(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increment(double amount) {
        Map<MeterRegistry, Counter> map = this.counters;
        synchronized (map) {
            this.counters.values().forEach(Counter::increment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double count() {
        Map<MeterRegistry, Counter> map = this.counters;
        synchronized (map) {
            return this.counters.values().stream().findFirst().orElse(NoopCounter.INSTANCE).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MeterRegistry registry) {
        Map<MeterRegistry, Counter> map = this.counters;
        synchronized (map) {
            this.counters.put(registry, registry.counter(this.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MeterRegistry registry) {
        Map<MeterRegistry, Counter> map = this.counters;
        synchronized (map) {
            this.counters.remove(registry);
        }
    }
}

