/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator.step;

import com.netflix.spectator.api.Registry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.spectator.SpectatorMeterRegistry;
import io.micrometer.core.instrument.spectator.step.StepMeasurement;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class StepSpectatorMeterRegistry
extends SpectatorMeterRegistry {
    private long stepMillis;

    public StepSpectatorMeterRegistry(Registry registry, Clock clock, long stepMillis) {
        super(registry, clock);
        this.stepMillis = stepMillis;
    }

    @Override
    public Meter register(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        List<Measurement> rateMeasurements = StreamSupport.stream(measurements.spliterator(), false).map(m -> {
            switch (m.getStatistic()) {
                case SumOfSquares: 
                case Count: 
                case Total: {
                    return new StepMeasurement(m.getValueFunction(), m.getStatistic(), this.clock, this.stepMillis);
                }
            }
            return m;
        }).collect(Collectors.toList());
        return super.register(id, type, rateMeasurements);
    }
}

