/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;

public class Bucket<T> {
    private final T tag;
    private final boolean percentile;
    private String tagStr;
    LongAdder value = new LongAdder();

    public Bucket(T tag, boolean percentile, long initialValue) {
        this.tag = tag;
        this.percentile = percentile;
        this.value.add(initialValue);
    }

    public boolean isPercentile() {
        return this.percentile;
    }

    public String getTag() {
        return this.getTag(Object::toString);
    }

    public String getTag(Function<T, String> tagSerializer) {
        if (this.tagStr != null) {
            return this.tagStr;
        }
        this.tagStr = tagSerializer == null ? this.tag.toString() : tagSerializer.apply(this.tag);
        return this.tagStr;
    }

    public Bucket<T> increment() {
        this.value.increment();
        return this;
    }

    public long getValue() {
        return this.value.longValue();
    }
}

