/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import io.micrometer.core.instrument.stats.hist.BucketFunction;
import io.micrometer.core.instrument.stats.hist.BucketListener;
import io.micrometer.core.instrument.stats.hist.Histogram;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

class DefaultHistogramBuilder<T>
implements Histogram.Builder<T> {
    private final BucketFunction<T> f;
    private Histogram.Type type = null;
    private List<BucketListener<T>> bucketListeners = new ArrayList<BucketListener<T>>();
    private boolean percentiles = false;

    DefaultHistogramBuilder(BucketFunction<T> f) {
        this.f = f;
    }

    @Override
    public Histogram<T> create(TimeUnit baseTimeUnit, Histogram.Type defaultType) {
        return new Histogram<T>(this.f, this.type == null ? defaultType : this.type, this.bucketListeners, this.percentiles);
    }

    @Override
    public Histogram.Builder<T> bucketListener(BucketListener<T> listener) {
        this.bucketListeners.add(listener);
        return this;
    }

    @Override
    public Histogram.Builder<T> type(Histogram.Type type) {
        this.type = type;
        return this;
    }

    @Override
    public Histogram.Builder<T> usedForPercentiles() {
        this.percentiles = true;
        return this;
    }
}

