/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import io.micrometer.core.instrument.stats.hist.Bucket;
import io.micrometer.core.instrument.stats.hist.BucketFunction;
import io.micrometer.core.instrument.stats.hist.BucketListener;
import io.micrometer.core.instrument.stats.hist.DefaultHistogramBuilder;
import io.micrometer.core.instrument.stats.hist.PercentileBuckets;
import io.micrometer.core.instrument.stats.hist.TimeScalingHistogramBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class Histogram<T> {
    private final NavigableMap<T, Bucket<T>> buckets = Collections.synchronizedNavigableMap(new TreeMap());
    private final BucketFunction<? extends T> f;
    private final Type type;
    private final List<BucketListener<T>> bucketListeners;
    private final boolean percentiles;

    public Histogram(BucketFunction<? extends T> f, Type type, List<BucketListener<T>> listeners, boolean percentiles) {
        this.f = f;
        this.type = type;
        this.bucketListeners = listeners;
        this.percentiles = percentiles;
    }

    public Collection<Bucket<T>> getBuckets() {
        return this.buckets.values();
    }

    public boolean isCumulative() {
        return this.type.equals((Object)Type.Cumulative);
    }

    public boolean isPercentiles() {
        return this.percentiles;
    }

    public Type getType() {
        return this.type;
    }

    public static <U> Builder<U> function(BucketFunction<U> f) {
        return new DefaultHistogramBuilder<U>(f);
    }

    public static Builder<Double> linear(double start, double width, int count) {
        return new DefaultHistogramBuilder<Double>(Histogram.linearFunction(start, width, count));
    }

    public static Builder<Double> linearTime(TimeUnit unit, double start, double width, int count) {
        return new TimeScalingHistogramBuilder(Histogram.linearFunction(start, width, count), unit);
    }

    public static Builder<Double> exponential(double start, double exp, int count) {
        return new DefaultHistogramBuilder<Double>(Histogram.exponentialFunction(start, exp, count));
    }

    public static Builder<Double> exponentialTime(TimeUnit unit, double start, double exp, int count) {
        return new TimeScalingHistogramBuilder(Histogram.exponentialFunction(start, exp, count), unit);
    }

    public static Builder<Double> percentiles() {
        return new DefaultHistogramBuilder<Double>(Histogram.percentilesFunction()).usedForPercentiles();
    }

    public static Builder<Double> percentilesTime() {
        return new TimeScalingHistogramBuilder(Histogram.percentilesFunction(), TimeUnit.NANOSECONDS).usedForPercentiles();
    }

    private static BucketFunction<Double> percentilesFunction() {
        return PercentileBuckets::bucketFunction;
    }

    private static BucketFunction<Double> linearFunction(double start, double width, int count) {
        return d -> {
            if (d > start + width * (double)(count - 1)) {
                return Double.POSITIVE_INFINITY;
            }
            return start + Math.ceil((d - start) / width) * width;
        };
    }

    private static BucketFunction<Double> exponentialFunction(double start, double exp, int count) {
        return d -> {
            if (d > Math.pow(exp, count - 1)) {
                return Double.POSITIVE_INFINITY;
            }
            if (d - start <= 0.0) {
                return start;
            }
            double log = Math.log(d) / Math.log(exp);
            return Math.pow(exp, Math.ceil(log));
        };
    }

    public void observe(double value) {
        T tag = this.f.bucket(value);
        this.buckets.compute(tag, (t, b) -> {
            if (this.isCumulative()) {
                NavigableMap<T, Bucket<T>> navigableMap = this.buckets;
                synchronized (navigableMap) {
                    this.buckets.tailMap(t).forEach((tailTag, bucket) -> bucket.increment());
                }
            }
            if (b == null) {
                Map.Entry<Object, Bucket<T>> ceiling;
                Bucket<Object> bucket2 = this.isCumulative() ? new Bucket<Object>(tag, this.percentiles, (ceiling = this.buckets.ceilingEntry(tag)) == null ? 1L : ceiling.getValue().getValue() + 1L) : new Bucket<Object>(tag, this.percentiles, 1L);
                this.bucketListeners.forEach(listener -> listener.bucketAdded(bucket2));
                return bucket2;
            }
            return b.increment();
        });
    }

    public static interface Builder<T> {
        public Histogram<T> create(TimeUnit var1, Type var2);

        public Builder bucketListener(BucketListener<T> var1);

        public Builder type(Type var1);

        public Builder usedForPercentiles();
    }

    public static enum Type {
        Cumulative,
        Normal;

    }
}

