/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import io.micrometer.core.instrument.stats.hist.BucketFunction;
import io.micrometer.core.instrument.stats.hist.BucketListener;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

class TimeScalingHistogramBuilder
implements Histogram.Builder<Double> {
    private final BucketFunction<Double> f;
    private final TimeUnit fUnits;
    private Histogram.Type type = null;
    private List<BucketListener<Double>> bucketListeners = new ArrayList<BucketListener<Double>>();
    private boolean percentiles = false;

    TimeScalingHistogramBuilder(BucketFunction<Double> f, TimeUnit fUnits) {
        this.f = f;
        this.fUnits = fUnits;
    }

    @Override
    public Histogram<Double> create(TimeUnit baseTimeUnit, Histogram.Type defaultType) {
        return new Histogram<Double>(this.timeScale(this.f, baseTimeUnit), this.type == null ? defaultType : this.type, this.bucketListeners, this.percentiles);
    }

    @Override
    public Histogram.Builder<Double> type(Histogram.Type type) {
        this.type = type;
        return this;
    }

    @Override
    public Histogram.Builder<Double> bucketListener(BucketListener<Double> listener) {
        this.bucketListeners.add(listener);
        return this;
    }

    private BucketFunction<Double> timeScale(BucketFunction<Double> f, TimeUnit baseTimeUnit) {
        return observed -> {
            double unscaledBucket = (Double)f.bucket(TimeUtils.convert(observed, baseTimeUnit, this.fUnits));
            return TimeUtils.convert(unscaledBucket, this.fUnits, baseTimeUnit);
        };
    }

    @Override
    public Histogram.Builder<Double> usedForPercentiles() {
        this.percentiles = true;
        return this;
    }
}

