/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.noop.NoopDistributionSummary;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class CompositeDistributionSummary
extends AbstractMeter
implements DistributionSummary,
CompositeMeter {
    private final Quantiles quantiles;
    private final Histogram.Builder<?> histogram;
    private final Map<MeterRegistry, DistributionSummary> distributionSummaries = Collections.synchronizedMap(new LinkedHashMap());

    CompositeDistributionSummary(Meter.Id id, Quantiles quantiles, Histogram.Builder<?> histogram) {
        super(id);
        this.quantiles = quantiles;
        this.histogram = histogram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(double amount) {
        Map<MeterRegistry, DistributionSummary> map = this.distributionSummaries;
        synchronized (map) {
            this.distributionSummaries.values().forEach(ds -> ds.record(amount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        Map<MeterRegistry, DistributionSummary> map = this.distributionSummaries;
        synchronized (map) {
            return this.distributionSummaries.values().stream().findFirst().orElse(NoopDistributionSummary.INSTANCE).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double totalAmount() {
        Map<MeterRegistry, DistributionSummary> map = this.distributionSummaries;
        synchronized (map) {
            return this.distributionSummaries.values().stream().findFirst().orElse(NoopDistributionSummary.INSTANCE).totalAmount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MeterRegistry registry) {
        Map<MeterRegistry, DistributionSummary> map = this.distributionSummaries;
        synchronized (map) {
            this.distributionSummaries.put(registry, registry.summary(this.getId(), this.histogram, this.quantiles));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MeterRegistry registry) {
        Map<MeterRegistry, DistributionSummary> map = this.distributionSummaries;
        synchronized (map) {
            this.distributionSummaries.remove(registry);
        }
    }
}

