/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import io.micrometer.core.instrument.stats.hist.Bucket;
import io.micrometer.core.instrument.stats.hist.BucketFilter;
import io.micrometer.core.instrument.stats.hist.BucketFunction;
import io.micrometer.core.instrument.stats.hist.Histogram;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DefaultHistogram<T>
implements Histogram<T> {
    protected final NavigableMap<T, Bucket<T>> buckets = Collections.synchronizedNavigableMap(new TreeMap());
    private final BucketFunction<? extends T> f;
    private final Histogram.Summation summation;
    private final Collection<BucketFilter<T>> domainFilters = new ArrayList<BucketFilter<T>>();

    DefaultHistogram(BucketFunction<T> f, Histogram.Summation summation) {
        this.f = f;
        this.summation = summation;
        this.buckets.putAll(f.buckets().stream().collect(Collectors.toMap(Bucket::getTag, Function.identity())));
    }

    @Override
    public Collection<Bucket<T>> getBuckets() {
        if (this.domainFilters.isEmpty()) {
            return this.buckets.values();
        }
        return this.buckets.values().stream().filter(bucket -> this.domainFilters.stream().allMatch(filter -> filter.shouldPublish(bucket))).collect(Collectors.toList());
    }

    @Override
    public Histogram<T> filterBuckets(BucketFilter<T> filter) {
        this.domainFilters.add(filter);
        return this;
    }

    @Override
    public Bucket<T> getBucket(T tag) {
        return (Bucket)this.buckets.get(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void observe(double value) {
        T tag = this.f.bucket(value);
        NavigableMap<T, Bucket<T>> navigableMap = this.buckets;
        synchronized (navigableMap) {
            Bucket bucket = (Bucket)this.buckets.get(tag);
            if (bucket != null) {
                bucket.increment();
            }
            if (this.isCumulative()) {
                this.buckets.tailMap(tag, false).forEach((tailTag, tailBucket) -> tailBucket.increment());
            }
        }
    }

    @Override
    public boolean isCumulative() {
        return Histogram.Summation.Cumulative.equals((Object)this.summation);
    }

    public static class Builder<U>
    extends Histogram.Builder<U> {
        Builder(BucketFunction<U> f) {
            super(f);
        }

        @Override
        public DefaultHistogram<U> create(Histogram.Summation defaultSummationMode) {
            return new DefaultHistogram(this.f, this.summation == null ? defaultSummationMode : this.summation);
        }
    }
}

