/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import io.micrometer.core.instrument.stats.hist.Bucket;
import io.micrometer.core.instrument.stats.hist.BucketFilter;
import io.micrometer.core.instrument.stats.hist.BucketFunction;
import io.micrometer.core.instrument.stats.hist.DoubleHistogram;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class TimeHistogram
implements Histogram<Double> {
    private final DoubleHistogram delegate;
    private final TimeUnit fUnits;
    private TimeUnit bucketTimeScale = TimeUnit.NANOSECONDS;

    TimeHistogram(DoubleHistogram delegate, TimeUnit fUnits) {
        this.delegate = delegate;
        this.fUnits = fUnits;
    }

    public void bucketTimeScale(TimeUnit bucketTimeScale) {
        this.bucketTimeScale = bucketTimeScale;
    }

    @Override
    public Collection<Bucket<Double>> getBuckets() {
        return this.delegate.getBuckets().stream().map(this::scaled).collect(Collectors.toList());
    }

    @Override
    public Histogram<Double> filterBuckets(BucketFilter<Double> filter) {
        return this.delegate.filterBuckets((Bucket<T> bucket) -> filter.shouldPublish(this.scaled(bucket)));
    }

    public void infinityBucket() {
        this.delegate.infinityBucket();
    }

    @Override
    public Bucket<Double> getBucket(Double tag) {
        return this.delegate.getBucket(tag);
    }

    @Override
    public void observe(double value) {
        this.delegate.observe(TimeUtils.convert(value, this.bucketTimeScale, this.fUnits));
    }

    @Override
    public boolean isCumulative() {
        return this.delegate.isCumulative();
    }

    private Bucket<Double> scaled(final Bucket<Double> unscaledBucket) {
        return new Bucket<Double>(Double.valueOf(TimeUtils.convert(unscaledBucket.getTag(), this.fUnits, this.bucketTimeScale)), unscaledBucket.getIndex().intValue()){

            @Override
            public long getValue() {
                return unscaledBucket.getValue();
            }
        };
    }

    public static class Builder
    extends Histogram.Builder<Double> {
        private final TimeUnit fUnits;

        Builder(BucketFunction<Double> f, TimeUnit fUnits) {
            super(f);
            this.fUnits = fUnits;
        }

        public TimeHistogram create(Histogram.Summation defaultSummationMode) {
            return new TimeHistogram(new DoubleHistogram(this.f, this.summation == null ? defaultSummationMode : this.summation), this.fUnits);
        }
    }
}

