/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Tag;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public final class Measurement {
    private final String name;
    private final SortedSet<Tag> tags = new TreeSet<Tag>(Comparator.comparing(Tag::getKey));
    private final double value;

    public Measurement(String name, List<Tag> tags, double value) {
        this.name = name;
        this.tags.addAll(tags);
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public SortedSet<Tag> getTags() {
        return this.tags;
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Measurement that = (Measurement)o;
        return Double.compare(that.value, this.value) == 0 && this.name.equals(that.name) && this.tags.equals(that.tags);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.tags.hashCode();
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Measurement{name='" + this.name + '\'' + ", tags=" + this.tags + ", value=" + this.value + '}';
    }
}

