/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.datadog;

import com.netflix.spectator.api.RegistryConfig;
import java.time.Duration;

public interface DatadogConfig
extends RegistryConfig {
    default public String apiKey() {
        String v = this.get("datadog.apiKey");
        if (v == null) {
            throw new IllegalStateException("datadog.apiKey must be set to report metrics to Datadog");
        }
        return v;
    }

    default public Duration step() {
        String v = this.get("datadog.step");
        return v == null ? Duration.ofSeconds(10L) : Duration.parse(v);
    }

    default public boolean enabled() {
        String v = this.get("datadog.enabled");
        return v == null || Boolean.valueOf(v) != false;
    }

    default public int numThreads() {
        String v = this.get("datadog.numThreads");
        return v == null ? 2 : Integer.parseInt(v);
    }

    default public Duration connectTimeout() {
        String v = this.get("datadog.connectTimeout");
        return v == null ? Duration.ofSeconds(1L) : Duration.parse(v);
    }

    default public Duration readTimeout() {
        String v = this.get("datadog.readTimeout");
        return v == null ? Duration.ofSeconds(10L) : Duration.parse(v);
    }

    default public int batchSize() {
        String v = this.get("datadog.batchSize");
        return v == null ? 10000 : Integer.parseInt(v);
    }

    default public String hostTag() {
        String v = this.get("datadog.hostTag");
        return v == null ? "instance" : v;
    }
}

