/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.datadog;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.impl.AtomicDouble;
import java.util.Collections;

class DatadogGauge
implements Gauge {
    private final Id id;
    private final Clock clock;
    private final AtomicDouble value;

    DatadogGauge(Id id, Clock clock) {
        this.id = id;
        this.clock = clock;
        this.value = new AtomicDouble(0.0);
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        return false;
    }

    public Iterable<Measurement> measure() {
        Measurement m = new Measurement(this.id, this.clock.wallTime(), this.value());
        return Collections.singletonList(m);
    }

    public void set(double v) {
        this.value.set(v);
    }

    public double value() {
        return this.value.get();
    }
}

