/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.datadog;

import com.netflix.spectator.api.AbstractRegistry;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.RegistryConfig;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.impl.Scheduler;
import io.micrometer.core.instrument.datadog.DatadogConfig;
import io.micrometer.core.instrument.datadog.DatadogCounter;
import io.micrometer.core.instrument.datadog.DatadogDistributionSummary;
import io.micrometer.core.instrument.datadog.DatadogGauge;
import io.micrometer.core.instrument.datadog.DatadogTimer;
import io.micrometer.core.instrument.datadog.StepClock;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class DatadogRegistry
extends AbstractRegistry {
    private final Clock clock;
    private final boolean enabled;
    private final Duration step;
    private final long stepMillis;
    private final URL metricsEndpoint;
    private final int connectTimeout;
    private final int readTimeout;
    private final int batchSize;
    private final int numThreads;
    private final String hostTag;
    private Scheduler scheduler;

    public DatadogRegistry(Clock clock, DatadogConfig config) {
        super((Clock)new StepClock(clock, config.step().toMillis()), (RegistryConfig)config);
        this.clock = clock;
        this.enabled = config.enabled();
        this.step = config.step();
        this.stepMillis = this.step.toMillis();
        try {
            this.metricsEndpoint = URI.create("https://app.datadoghq.com/api/v1/series?api_key=" + config.apiKey()).toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.connectTimeout = (int)config.connectTimeout().toMillis();
        this.readTimeout = (int)config.readTimeout().toMillis();
        this.batchSize = config.batchSize();
        this.numThreads = config.numThreads();
        this.hostTag = config.hostTag();
    }

    public void start() {
        if (this.scheduler == null) {
            if (this.enabled) {
                Scheduler.Options options = new Scheduler.Options().withFrequency(Scheduler.Policy.FIXED_RATE_SKIP_IF_LONG, this.step).withInitialDelay(Duration.ofMillis(this.getInitialDelay(this.stepMillis))).withStopOnFailure(false);
                this.scheduler = new Scheduler((Registry)this, "spring-metrics-datadog", this.numThreads);
                this.scheduler.schedule(options, this::collectData);
                this.logger.info("started collecting metrics every {} reporting to {}", (Object)this.step, (Object)this.metricsEndpoint);
            } else {
                this.logger.info("publishing is not enabled");
            }
        } else {
            this.logger.warn("registry already started, ignoring duplicate request");
        }
    }

    private long getInitialDelay(long stepSize) {
        long offset;
        long stepBoundary;
        long now = this.clock.wallTime();
        long delay = now - (stepBoundary = now / stepSize * stepSize);
        if (delay < (offset = stepSize / 10L)) {
            return delay + offset;
        }
        if (delay > stepSize - offset) {
            return stepSize - offset;
        }
        return delay;
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
            this.logger.info("stopped collecting metrics every {}ms reporting to {}", (Object)this.step, (Object)this.metricsEndpoint);
        } else {
            this.logger.warn("registry stopped, but was never started");
        }
    }

    private void collectData() {
        if (this.enabled) {
            try {
                for (List<Measurement> batch : this.getBatches()) {
                    HttpURLConnection con = (HttpURLConnection)this.metricsEndpoint.openConnection();
                    con.setConnectTimeout(this.connectTimeout);
                    con.setReadTimeout(this.readTimeout);
                    con.setRequestMethod("POST");
                    con.setRequestProperty("Content-Type", "application/json");
                    con.setDoOutput(true);
                    String body = "{\"series\":[" + batch.stream().map(m -> {
                        Iterable tags = m.id().tags();
                        String host = this.hostTag == null ? "" : StreamSupport.stream(tags.spliterator(), false).filter(t -> this.hostTag.equals(t.key())).findAny().map(t -> ",\"host\":" + t.value()).orElse("");
                        String tagsArray = tags.iterator().hasNext() ? ",\"tags\":[" + StreamSupport.stream(tags.spliterator(), false).map(t -> "\"" + t.key() + ":" + t.value() + "\"").collect(Collectors.joining(",")) + "]" : "";
                        return "{\"metric\":\"" + m.id().name() + "\",\"points\":[[" + m.timestamp() / 1000L + ", " + m.value() + "]]" + host + tagsArray + "}";
                    }).collect(Collectors.joining(",")) + "]}";
                    try (OutputStream os = con.getOutputStream();){
                        os.write(body.getBytes());
                        os.flush();
                    }
                    int status = con.getResponseCode();
                    if (status >= 200 && status < 300) {
                        this.logger.info("successfully sent " + batch.size() + " metrics to datadog");
                    } else if (status >= 400) {
                        try (InputStream in = status >= 400 ? con.getErrorStream() : con.getInputStream();){
                            this.logger.error("failed to send metrics: " + new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n")));
                        }
                    } else {
                        this.logger.error("failed to send metrics: http " + status);
                    }
                    con.disconnect();
                }
            }
            catch (Exception e) {
                this.logger.warn("failed to send metrics", (Throwable)e);
            }
        }
    }

    List<Measurement> getMeasurements() {
        return this.stream().flatMap(m -> StreamSupport.stream(m.measure().spliterator(), false)).collect(Collectors.toList());
    }

    private List<List<Measurement>> getBatches() {
        ArrayList<List<Measurement>> batches = new ArrayList<List<Measurement>>();
        List<Measurement> ms = this.getMeasurements();
        for (int i = 0; i < ms.size(); i += this.batchSize) {
            List<Measurement> batch = ms.subList(i, Math.min(ms.size(), i + this.batchSize));
            batches.add(batch);
        }
        return batches;
    }

    protected Counter newCounter(Id id) {
        return new DatadogCounter(id, this.clock, this.stepMillis);
    }

    protected DistributionSummary newDistributionSummary(Id id) {
        return new DatadogDistributionSummary(id, this.clock, this.stepMillis);
    }

    protected Timer newTimer(Id id) {
        return new DatadogTimer(id, this.clock, this.stepMillis);
    }

    protected Gauge newGauge(Id id) {
        return new DatadogGauge(id, this.clock());
    }
}

