/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.internal;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Tag;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MeterId {
    private final String name;
    private final List<Tag> tags;

    public MeterId(String name, Iterable<Tag> tags) {
        this.name = name;
        this.tags = StreamSupport.stream(tags.spliterator(), false).sorted(Comparator.comparing(Tag::getKey)).collect(Collectors.toList());
    }

    public MeterId(String name, Tag ... tags) {
        this(name, Arrays.asList(tags));
    }

    public String getName() {
        return this.name;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeterId meterId = (MeterId)o;
        return this.name.equals(meterId.name) && this.tags.equals(meterId.tags);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.tags.hashCode();
        return result;
    }

    public String toString() {
        return "MeterId{name='" + this.name + '\'' + ", tags=" + this.tags + '}';
    }

    public MeterId withTags(Tag ... extraTags) {
        return new MeterId(this.name, Stream.concat(this.tags.stream(), Stream.of(extraTags)).collect(Collectors.toList()));
    }

    public MeterId withTags(Iterable<Tag> extraTags) {
        return new MeterId(this.name, Stream.concat(this.tags.stream(), StreamSupport.stream(extraTags.spliterator(), false)).collect(Collectors.toList()));
    }

    public Measurement measurement(double value) {
        return new Measurement(this.name, this.tags, value);
    }
}

