/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.prometheus;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.prometheus.CustomCollectorChild;
import io.prometheus.client.Collector;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CustomPrometheusLongTaskTimer
extends Collector {
    private final Clock clock;
    private final String name;
    private final List<String> tagKeys;
    private final Collection<Child> children = new ConcurrentLinkedQueue<Child>();

    public CustomPrometheusLongTaskTimer(String name, List<String> tagKeys, Clock clock) {
        this.clock = clock;
        this.name = name;
        this.tagKeys = tagKeys;
    }

    Child child(Iterable<Tag> tags) {
        Child child = new Child(tags);
        this.children.add(child);
        return child;
    }

    public List<Collector.MetricFamilySamples> collect() {
        return Collections.singletonList(new Collector.MetricFamilySamples(this.name, Collector.Type.UNTYPED, " ", this.children.stream().flatMap(Child::collect).collect(Collectors.toList())));
    }

    class Child
    implements CustomCollectorChild {
        private final List<String> tagValues;
        private final ConcurrentMap<Long, Long> tasks = new ConcurrentHashMap<Long, Long>();
        private final AtomicLong nextTask = new AtomicLong(0L);

        Child(Iterable<Tag> tags) {
            this.tagValues = StreamSupport.stream(tags.spliterator(), false).map(Tag::getValue).collect(Collectors.toList());
        }

        @Override
        public Stream<Collector.MetricFamilySamples.Sample> collect() {
            Stream.Builder<Collector.MetricFamilySamples.Sample> samples = Stream.builder();
            LinkedList<String> activeTasksKeys = new LinkedList<String>(CustomPrometheusLongTaskTimer.this.tagKeys);
            activeTasksKeys.add("statistic");
            LinkedList<String> activeTasksValues = new LinkedList<String>(this.tagValues);
            activeTasksValues.add("activeTasks");
            samples.add(new Collector.MetricFamilySamples.Sample(CustomPrometheusLongTaskTimer.this.name, activeTasksKeys, activeTasksValues, (double)this.activeTasks()));
            LinkedList<String> durationKeys = new LinkedList<String>(CustomPrometheusLongTaskTimer.this.tagKeys);
            durationKeys.add("statistic");
            LinkedList<String> durationValues = new LinkedList<String>(this.tagValues);
            durationValues.add("duration");
            samples.add(new Collector.MetricFamilySamples.Sample(CustomPrometheusLongTaskTimer.this.name, durationKeys, durationValues, (double)this.duration()));
            return samples.build();
        }

        public long start() {
            long task = this.nextTask.getAndIncrement();
            this.tasks.put(task, CustomPrometheusLongTaskTimer.this.clock.monotonicTime());
            return task;
        }

        public long stop(long task) {
            Long startTime = (Long)this.tasks.get(task);
            if (startTime != null) {
                this.tasks.remove(task);
                return CustomPrometheusLongTaskTimer.this.clock.monotonicTime() - startTime;
            }
            return -1L;
        }

        public long duration(long task) {
            Long startTime = (Long)this.tasks.get(task);
            return startTime != null ? CustomPrometheusLongTaskTimer.this.clock.monotonicTime() - startTime : -1L;
        }

        public long duration() {
            long now = CustomPrometheusLongTaskTimer.this.clock.monotonicTime();
            long sum = 0L;
            Iterator iterator = this.tasks.values().iterator();
            while (iterator.hasNext()) {
                long startTime = (Long)iterator.next();
                sum += now - startTime;
            }
            return sum;
        }

        public int activeTasks() {
            return this.tasks.size();
        }
    }
}

