/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.internal.MeterId;
import io.micrometer.core.instrument.simple.AbstractSimpleMeter;
import io.micrometer.core.instrument.simple.SimpleUtils;
import java.util.Arrays;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class SimpleDistributionSummary
extends AbstractSimpleMeter
implements DistributionSummary {
    private LongAdder count = new LongAdder();
    private DoubleAdder amount = new DoubleAdder();

    public SimpleDistributionSummary(MeterId id) {
        super(id);
    }

    @Override
    public void record(double amount) {
        if (amount >= 0.0) {
            this.count.increment();
            this.amount.add(amount);
        }
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalAmount() {
        return this.amount.doubleValue();
    }

    @Override
    public Iterable<Measurement> measure() {
        return Arrays.asList(this.id.withTags(SimpleUtils.typeTag(this.getType()), Tag.of("statistic", "count")).measurement(this.count()), this.id.withTags(SimpleUtils.typeTag(this.getType()), Tag.of("statistic", "amount")).measurement(this.totalAmount()));
    }
}

