/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.internal.MeterId;
import io.micrometer.core.instrument.simple.AbstractSimpleMeter;
import io.micrometer.core.instrument.simple.SimpleUtils;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.function.ToDoubleFunction;

public class SimpleGauge<T>
extends AbstractSimpleMeter
implements Gauge {
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> value;

    public SimpleGauge(MeterId id, T obj, ToDoubleFunction<T> value) {
        super(id);
        this.ref = new WeakReference<T>(obj);
        this.value = value;
    }

    @Override
    public double value() {
        return this.value.applyAsDouble(this.ref.get());
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.singletonList(this.id.withTags(SimpleUtils.typeTag(this.getType())).measurement(this.value()));
    }
}

