/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.internal.AbstractTimer;
import io.micrometer.core.instrument.internal.MeterId;
import io.micrometer.core.instrument.internal.TimeUtils;
import io.micrometer.core.instrument.simple.SimpleUtils;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class SimpleTimer
extends AbstractTimer {
    private LongAdder count = new LongAdder();
    private LongAdder totalTime = new LongAdder();

    public SimpleTimer(MeterId id, Clock clock) {
        super(id, clock);
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.count.increment();
            this.totalTime.add(TimeUnit.NANOSECONDS.convert(amount, unit));
        }
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.totalTime.doubleValue(), unit);
    }

    @Override
    public Iterable<Measurement> measure() {
        return Arrays.asList(this.id.withTags(SimpleUtils.typeTag(this.getType()), Tag.of("statistic", "count")).measurement(this.count()), this.id.withTags(SimpleUtils.typeTag(this.getType()), Tag.of("statistic", "amount")).measurement(this.totalTime(TimeUnit.NANOSECONDS)));
    }
}

