/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;

public class Bucket<T> {
    private final T tag;
    private String tagStr;
    LongAdder value = new LongAdder();

    public Bucket(T tag) {
        this.tag = tag;
    }

    public Bucket(T tag, long initialValue) {
        this.tag = tag;
        this.value.add(initialValue);
    }

    public String getTag() {
        return this.getTag(Object::toString);
    }

    public String getTag(Function<T, String> tagSerializer) {
        if (this.tagStr != null) {
            return this.tagStr;
        }
        this.tagStr = tagSerializer == null ? this.tag.toString() : tagSerializer.apply(this.tag);
        return this.tagStr;
    }

    public Bucket<T> increment() {
        this.value.increment();
        return this;
    }

    public double getValue() {
        return this.value.doubleValue();
    }
}

