/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import io.micrometer.core.instrument.stats.hist.Bucket;
import io.micrometer.core.instrument.stats.hist.BucketFunction;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.hist.TimeScaleNormalHistogram;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class NormalHistogram<T>
implements Histogram<T> {
    protected final BucketFunction<? extends T> f;
    private final Map<T, Bucket<T>> buckets = new ConcurrentHashMap<T, Bucket<T>>();

    public NormalHistogram(BucketFunction<? extends T> f) {
        this.f = f;
    }

    @Override
    public void observe(double value) {
        Object tag = this.f.bucket(value);
        this.buckets.compute(tag, (t, b) -> b == null ? new Bucket(tag, 1L) : b.increment());
    }

    @Override
    public Collection<Bucket<T>> getBuckets() {
        return this.buckets.values();
    }

    public static <T> NormalHistogram<T> buckets(BucketFunction<T> bucketFunction) {
        return new NormalHistogram<T>(bucketFunction);
    }

    public static TimeScaleNormalHistogram buckets(BucketFunction<Double> bucketFunction, TimeUnit timeScale) {
        return new TimeScaleNormalHistogram(bucketFunction, timeScale);
    }

    public static BucketFunction<Double> linear(double start, double width, int count) {
        return d -> {
            if (d > start + width * (double)(count - 1)) {
                return Double.POSITIVE_INFINITY;
            }
            return start + Math.ceil((d - start) / width) * width;
        };
    }

    public static BucketFunction<Double> exponential(double start, double exp, int count) {
        return d -> {
            if (d > Math.pow(exp, count - 1)) {
                return Double.POSITIVE_INFINITY;
            }
            if (d - start <= 0.0) {
                return start;
            }
            double log = Math.log(d) / Math.log(exp);
            return Math.pow(exp, Math.ceil(log));
        };
    }
}

