/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import io.micrometer.core.instrument.internal.TimeUtils;
import io.micrometer.core.instrument.stats.hist.CumulativeBucketFunction;
import io.micrometer.core.instrument.stats.hist.CumulativeHistogram;
import io.micrometer.core.instrument.stats.hist.FixedCumulativeBucketFunction;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class TimeScaleCumulativeHistogram
extends CumulativeHistogram<Double> {
    private final TimeUnit timeScale;

    public TimeScaleCumulativeHistogram(CumulativeBucketFunction<Double> f, TimeUnit timeScale) {
        super(f);
        this.timeScale = timeScale;
    }

    public TimeScaleCumulativeHistogram shiftScale(TimeUnit targetUnit) {
        if (targetUnit.equals((Object)this.timeScale)) {
            return this;
        }
        return new TimeScaleCumulativeHistogram(new ScaledCumulativeBucketFunction(this.timeScale, targetUnit), targetUnit);
    }

    class ScaledCumulativeBucketFunction
    extends FixedCumulativeBucketFunction<Double> {
        ScaledCumulativeBucketFunction(TimeUnit sourceUnit, TimeUnit targetUnit) {
            super((double d) -> d, TimeScaleCumulativeHistogram.this.f.buckets().stream().map(d -> TimeUtils.convert(d, sourceUnit, targetUnit)).collect(Collectors.toSet()), TimeScaleCumulativeHistogram.this.f.bucketComparator());
        }
    }
}

