/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import io.micrometer.core.instrument.internal.TimeUtils;
import io.micrometer.core.instrument.stats.hist.BucketFunction;
import io.micrometer.core.instrument.stats.hist.NormalHistogram;
import java.util.concurrent.TimeUnit;

public class TimeScaleNormalHistogram
extends NormalHistogram<Double> {
    private final TimeUnit timeScale;

    public TimeScaleNormalHistogram(BucketFunction<? extends Double> f, TimeUnit timeScale) {
        super(f);
        this.timeScale = timeScale;
    }

    public TimeScaleNormalHistogram shiftScale(TimeUnit targetUnit) {
        if (targetUnit.equals((Object)this.timeScale)) {
            return this;
        }
        return new TimeScaleNormalHistogram(new ScaledBucketFunction(this.timeScale, targetUnit), targetUnit);
    }

    class ScaledBucketFunction
    implements BucketFunction<Double> {
        private final TimeUnit targetUnit;
        private final TimeUnit sourceUnit;

        ScaledBucketFunction(TimeUnit sourceUnit, TimeUnit targetUnit) {
            this.sourceUnit = sourceUnit;
            this.targetUnit = targetUnit;
        }

        @Override
        public Double bucket(double d) {
            return TimeUtils.convert((Double)TimeScaleNormalHistogram.this.f.bucket(TimeUtils.convert(d, this.targetUnit, this.sourceUnit)), this.sourceUnit, this.targetUnit);
        }
    }
}

