/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.simple.AbstractSimpleMeter;
import io.micrometer.core.instrument.simple.SimpleUtils;
import io.micrometer.core.instrument.util.MeterId;
import java.util.Collections;
import java.util.concurrent.atomic.DoubleAdder;

public class SimpleCounter
extends AbstractSimpleMeter
implements Counter {
    private static final Tag TYPE_TAG = SimpleUtils.typeTag(Meter.Type.Counter);
    private final MeterId countId;
    private DoubleAdder count = new DoubleAdder();

    public SimpleCounter(MeterId id) {
        super(id);
        this.countId = id.withTags(TYPE_TAG);
    }

    @Override
    public void increment() {
        this.count.add(1.0);
    }

    @Override
    public void increment(double amount) {
        this.count.add(amount);
    }

    @Override
    public double count() {
        return this.count.doubleValue();
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.singletonList(this.countId.measurement(this.count()));
    }
}

