/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator;

import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Timer;
import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.spectator.SpectatorUtils;
import io.micrometer.core.instrument.util.MeterId;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;

public class SpectatorTimer
extends AbstractTimer {
    private Timer timer;

    SpectatorTimer(Timer timer, Clock clock) {
        super(new MeterId(timer.id().name(), SpectatorUtils.tags((Meter)timer)), clock);
        this.timer = timer;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.timer.record(unit.toNanos(amount), TimeUnit.NANOSECONDS);
    }

    @Override
    public long count() {
        return this.timer.count();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.timer.totalTime(), unit);
    }

    @Override
    public Iterable<Measurement> measure() {
        return SpectatorUtils.measurements((Meter)this.timer);
    }
}

