/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.quantile;

import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class CKMSQuantiles
implements Quantiles {
    private int count = 0;
    private final LinkedList<Item> sample;
    private double[] buffer = new double[500];
    private int bufferCount = 0;
    private final Quantile[] quantiles;
    private final Collection<Double> registered;

    CKMSQuantiles(Quantile[] quantiles) {
        this.quantiles = quantiles;
        this.registered = new ArrayList<Double>();
        for (Quantile quantile : quantiles) {
            this.registered.add(quantile.getQuantile());
        }
        this.sample = new LinkedList();
    }

    @Override
    public void observe(double value) {
        this.buffer[this.bufferCount] = value;
        ++this.bufferCount;
        if (this.bufferCount == this.buffer.length) {
            this.insertBatch();
            this.compress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double get(double q) {
        this.insertBatch();
        this.compress();
        LinkedList<Item> linkedList = this.sample;
        synchronized (linkedList) {
            if (this.sample.size() == 0) {
                return Double.NaN;
            }
            int rankMin = 0;
            int desired = (int)(q * (double)this.count);
            ListIterator it = this.sample.listIterator();
            Item cur = (Item)it.next();
            while (it.hasNext()) {
                Item prev = cur;
                cur = (Item)it.next();
                if (!((double)((rankMin += prev.g) + cur.g + cur.delta) > (double)desired + this.allowableError(desired) / 2.0)) continue;
                return prev.value;
            }
            return this.sample.getLast().value;
        }
    }

    @Override
    public Collection<Double> monitored() {
        return this.registered;
    }

    private double allowableError(int rank) {
        int size = this.sample.size();
        double minError = size + 1;
        for (Quantile q : this.quantiles) {
            double error = (double)rank <= q.quantile * (double)size ? q.u * (double)(size - rank) : q.v * (double)rank;
            if (!(error < minError)) continue;
            minError = error;
        }
        return minError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertBatch() {
        if (this.bufferCount == 0) {
            return;
        }
        Arrays.sort(this.buffer, 0, this.bufferCount);
        LinkedList<Item> linkedList = this.sample;
        synchronized (linkedList) {
            int start = 0;
            if (this.sample.size() == 0) {
                Item newItem = new Item(this.buffer[0], 1, 0);
                this.sample.add(newItem);
                ++start;
                ++this.count;
            }
            ListIterator<Item> it = this.sample.listIterator();
            Item item = (Item)it.next();
            for (int i = start; i < this.bufferCount; ++i) {
                double v = this.buffer[i];
                while (it.nextIndex() < this.sample.size() && item.value < v) {
                    item = (Item)it.next();
                }
                if (item.value > v) {
                    it.previous();
                }
                int delta = it.previousIndex() == 0 || it.nextIndex() == this.sample.size() ? 0 : (int)Math.floor(this.allowableError(it.nextIndex())) - 1;
                Item newItem = new Item(v, 1, delta);
                it.add(newItem);
                ++this.count;
                item = newItem;
            }
        }
        this.bufferCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress() {
        LinkedList<Item> linkedList = this.sample;
        synchronized (linkedList) {
            if (this.sample.size() < 2) {
                return;
            }
            ListIterator it = this.sample.listIterator();
            Item next = (Item)it.next();
            while (it.hasNext()) {
                Item prev = next;
                next = (Item)it.next();
                if (!((double)(prev.g + next.g + next.delta) <= this.allowableError(it.previousIndex()))) continue;
                next.g += prev.g;
                it.previous();
                it.previous();
                it.remove();
                it.next();
            }
        }
    }

    public Quantile[] getQuantiles() {
        return this.quantiles;
    }

    public static Builder quantile(double quantile, double error) {
        return new Builder().quantile(quantile, error);
    }

    public static class Builder {
        List<Quantile> quantiles = new ArrayList<Quantile>();

        public Builder quantile(double quantile, double error) {
            this.quantiles.add(new Quantile(quantile, error));
            return this;
        }

        public CKMSQuantiles create() {
            return new CKMSQuantiles(this.quantiles.toArray(new Quantile[this.quantiles.size()]));
        }
    }

    public static class Quantile {
        final double quantile;
        final double error;
        final double u;
        final double v;

        Quantile(double quantile, double error) {
            this.quantile = quantile;
            this.error = error;
            this.u = 2.0 * error / (1.0 - quantile);
            this.v = 2.0 * error / quantile;
        }

        double getQuantile() {
            return this.quantile;
        }

        public double getError() {
            return this.error;
        }

        public String toString() {
            return String.format("Q{q=%.3f, eps=%.3f})", this.quantile, this.error);
        }
    }

    private class Item {
        public final double value;
        int g;
        final int delta;

        Item(double value, int lower_delta, int delta) {
            this.value = value;
            this.g = lower_delta;
            this.delta = delta;
        }

        public String toString() {
            return String.format("%4.3f, %d, %d", this.value, this.g, this.delta);
        }
    }
}

