/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.quantile;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;

public class SlidingWindow<T>
implements Serializable {
    private static final long serialVersionUID = 5971578246884329784L;
    private LinkedList<Element<T>> elements;
    private Integer windowSize;

    public SlidingWindow(Integer windowSize) {
        if (windowSize < 0) {
            windowSize = windowSize * -1;
        }
        this.windowSize = windowSize;
        this.elements = new LinkedList();
    }

    public void add(T element) {
        Element<T> newElement = new Element<T>(element, this.windowSize, 0);
        this.elements.addFirst(newElement);
    }

    public void add(T element, Integer size) {
        if (size > this.windowSize) {
            throw new RuntimeException("Size of element exceeds the size of the sliding window.");
        }
        if (size < 0) {
            throw new RuntimeException("The size of an element can't be a negative integer.");
        }
        Element<T> newElement = new Element<T>(element, this.windowSize - size, size);
        this.elements.addFirst(newElement);
    }

    public void slideWindowByOnePosition() {
        this.refreshWindow();
        this.shiftElementsByOne();
    }

    public void slideWindow(Integer positions) {
        if (positions < 0) {
            throw new RuntimeException("You can't go back in time...");
        }
        this.refreshWindow();
        this.shiftElements(positions);
    }

    public T get(Integer index) {
        return this.elements.get(index).getElement();
    }

    public T getOldestElement() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.getLast().getElement();
    }

    public T getNewestElement() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.getFirst().getElement();
    }

    public Collection<T> getAll() {
        LinkedList<T> elements = new LinkedList<T>();
        for (int i = 0; i < this.elements.size(); ++i) {
            elements.add(this.elements.get(i).getElement());
        }
        return elements;
    }

    public Collection<Integer> getAllLifeTimes() {
        LinkedList<Integer> lifeTimes = new LinkedList<Integer>();
        for (int i = 0; i < this.elements.size(); ++i) {
            lifeTimes.add(this.elements.get(i).getTimeToLive());
        }
        return lifeTimes;
    }

    public Integer getLifeTime(Integer index) {
        return this.elements.get(index).getTimeToLive();
    }

    public Integer getWindowSize() {
        return this.windowSize;
    }

    public Integer getSize(Integer index) {
        return this.elements.get(index).getSize();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    private void refreshWindow() {
        while (!this.elements.isEmpty() && this.elements.getLast().getTimeToLive() < 0) {
            this.elements.removeLast();
        }
    }

    private void shiftElementsByOne() {
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).decrementTimeToLiveByOne();
        }
    }

    private void shiftElements(Integer positions) {
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).decrementTimeToLive(positions);
        }
    }

    private class Element<E>
    implements Serializable {
        private static final long serialVersionUID = 3908165358308721662L;
        private Integer timeToLive;
        private Integer size;
        private E element;

        Element(E element, Integer timeToLive, Integer size) {
            this.element = element;
            this.timeToLive = timeToLive;
            this.size = size;
        }

        void decrementTimeToLive(Integer amount) {
            Element element = this;
            element.timeToLive = element.timeToLive - amount;
        }

        void decrementTimeToLiveByOne() {
            Element element = this;
            Integer n = element.timeToLive;
            Integer n2 = element.timeToLive = Integer.valueOf(element.timeToLive - 1);
        }

        Integer getTimeToLive() {
            return this.timeToLive;
        }

        E getElement() {
            return this.element;
        }

        public Integer getSize() {
            return this.size;
        }

        public String toString() {
            return "[ TTL: " + this.timeToLive + ", size: " + this.size + ", element: " + this.element + " ]";
        }
    }
}

