/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToDoubleFunction;

public interface MeterRegistry {
    public Collection<Meter> getMeters();

    public void commonTags(Iterable<Tag> var1);

    default public void commonTags(String ... tags) {
        this.commonTags(Tags.zip(tags));
    }

    default public <M extends Meter> Optional<M> findMeter(Class<M> mClass, String name, String ... tags) {
        return this.findMeter(mClass, name, Tags.zip(tags));
    }

    public <M extends Meter> Optional<M> findMeter(Class<M> var1, String var2, Iterable<Tag> var3);

    default public Optional<Meter> findMeter(Meter.Type type, String name, String ... tags) {
        return this.findMeter(type, name, Tags.zip(tags));
    }

    public Optional<Meter> findMeter(Meter.Type var1, String var2, Iterable<Tag> var3);

    public Clock getClock();

    public Counter counter(String var1, Iterable<Tag> var2);

    default public Counter counter(String name, String ... tags) {
        return this.counter(name, Tags.zip(tags));
    }

    public DistributionSummary.Builder summaryBuilder(String var1);

    default public DistributionSummary summary(String name, Iterable<Tag> tags) {
        return this.summaryBuilder(name).tags(tags).create();
    }

    default public DistributionSummary summary(String name, String ... tags) {
        return this.summary(name, Tags.zip(tags));
    }

    public Timer.Builder timerBuilder(String var1);

    default public Timer timer(String name, Iterable<Tag> tags) {
        return this.timerBuilder(name).tags(tags).create();
    }

    default public Timer timer(String name, String ... tags) {
        return this.timer(name, Tags.zip(tags));
    }

    public LongTaskTimer longTaskTimer(String var1, Iterable<Tag> var2);

    default public LongTaskTimer longTaskTimer(String name, String ... tags) {
        return this.longTaskTimer(name, Tags.zip(tags));
    }

    public MeterRegistry register(Meter var1);

    public <T> T gauge(String var1, Iterable<Tag> var2, T var3, ToDoubleFunction<T> var4);

    default public <T extends Number> T gauge(String name, Iterable<Tag> tags, T number) {
        return (T)this.gauge(name, tags, number, Number::doubleValue);
    }

    default public <T extends Number> T gauge(String name, T number) {
        return this.gauge(name, Collections.emptyList(), number);
    }

    default public <T> T gauge(String name, T obj, ToDoubleFunction<T> f) {
        return this.gauge(name, Collections.emptyList(), obj, f);
    }

    default public <T extends Collection<?>> T collectionSize(T collection, String name, Iterable<Tag> tags) {
        return (T)this.gauge(name, tags, collection, Collection::size);
    }

    default public <T extends Collection<?>> T collectionSize(T collection, String name, Tag ... tags) {
        return this.collectionSize(collection, name, Arrays.asList(tags));
    }

    default public <T extends Map<?, ?>> T mapSize(T map, String name, Iterable<Tag> tags) {
        return (T)this.gauge(name, tags, map, Map::size);
    }

    default public <T extends Map<?, ?>> T mapSize(T map, String name, String ... tags) {
        return this.mapSize(map, name, Tags.zip(tags));
    }
}

