/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Histogram;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.dropwizard.AbstractDropwizardMeter;
import io.micrometer.core.instrument.util.MeterId;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.DoubleAdder;

public class DropwizardDistributionSummary
extends AbstractDropwizardMeter
implements DistributionSummary {
    private final Histogram impl;
    private final DoubleAdder totalAmount = new DoubleAdder();

    DropwizardDistributionSummary(MeterId id, Histogram impl) {
        super(id);
        this.impl = impl;
    }

    @Override
    public List<Measurement> measure() {
        return Collections.singletonList(this.id.measurement(this.impl.getSnapshot().getMean()));
    }

    @Override
    public void record(double amount) {
        if (amount >= 0.0) {
            this.impl.update((long)amount);
            this.totalAmount.add(amount);
        }
    }

    @Override
    public long count() {
        return this.impl.getCount();
    }

    @Override
    public double totalAmount() {
        return this.totalAmount.doubleValue();
    }
}

