/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.micrometer.core.instrument.AbstractMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TagFormatter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.dropwizard.DropwizardCounter;
import io.micrometer.core.instrument.dropwizard.DropwizardDistributionSummary;
import io.micrometer.core.instrument.dropwizard.DropwizardGauge;
import io.micrometer.core.instrument.dropwizard.DropwizardTimer;
import io.micrometer.core.instrument.simple.SimpleLongTaskTimer;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.core.instrument.util.MapAccess;
import io.micrometer.core.instrument.util.MeterId;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;

public class DropwizardMeterRegistry
extends AbstractMeterRegistry {
    private final MetricRegistry registry;
    private final ConcurrentMap<MeterId, Meter> meterMap = new ConcurrentHashMap<MeterId, Meter>();
    private final HierarchicalNameMapper nameMapper;
    private final TagFormatter tagFormatter;

    public DropwizardMeterRegistry(HierarchicalNameMapper nameMapper, Clock clock, TagFormatter tagFormatter) {
        super(clock);
        this.registry = new MetricRegistry();
        this.nameMapper = nameMapper;
        this.tagFormatter = tagFormatter;
    }

    public MetricRegistry getDropwizardRegistry() {
        return this.registry;
    }

    @Override
    public Collection<Meter> getMeters() {
        return this.meterMap.values();
    }

    @Override
    public <M extends Meter> Optional<M> findMeter(Class<M> mClass, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.keySet().stream().filter(id -> id.getName().equals(name)).filter(id -> id.getTags().containsAll(tagsToMatch)).findAny().map(this.meterMap::get).filter(mClass::isInstance).map(mClass::cast);
    }

    @Override
    public Optional<Meter> findMeter(Meter.Type type, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.keySet().stream().filter(id -> id.getName().equals(name)).filter(id -> id.getTags().containsAll(tagsToMatch)).findAny().map(this.meterMap::get).filter(m -> m.getType().equals((Object)type));
    }

    @Override
    public Counter counter(String name, Iterable<Tag> tags) {
        return MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, this.withCommonTags(tags)), id -> new DropwizardCounter((MeterId)id, this.registry.meter(this.toDropwizardName((MeterId)id))));
    }

    @Override
    public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
        return MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, this.withCommonTags(tags)), id -> {
            SimpleLongTaskTimer ltt = new SimpleLongTaskTimer((MeterId)id, this.clock);
            this.registry.register(this.toDropwizardName(id.withName(name + "_active")), (Metric)((Gauge)ltt::activeTasks));
            this.registry.register(this.toDropwizardName(id.withName(name + "_duration")), (Metric)((Gauge)ltt::duration));
            return ltt;
        });
    }

    @Override
    public MeterRegistry register(Meter meter) {
        MapAccess.computeIfAbsent(this.meterMap, new MeterId(meter.getName(), meter.getTags()), id -> {
            int i = 0;
            while (i < meter.measure().size()) {
                int index = i++;
                this.registry.register(this.toDropwizardName((MeterId)id), (Metric)((Gauge)() -> meter.measure().get(index).getValue()));
            }
            return meter;
        });
        return this;
    }

    @Override
    public <T> T gauge(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, this.withCommonTags(tags)), id -> {
            WeakReference<Object> ref = new WeakReference<Object>(obj);
            Gauge gauge = () -> f.applyAsDouble(ref.get());
            this.registry.register(this.toDropwizardName((MeterId)id), (Metric)gauge);
            return new DropwizardGauge((MeterId)id, (Gauge<Double>)gauge);
        });
        return obj;
    }

    private String toDropwizardName(MeterId id) {
        Collection formattedTags = id.getTags().stream().map(t -> Tag.of(this.tagFormatter.formatTagKey(t.getKey()), this.tagFormatter.formatTagValue(t.getValue()))).collect(Collectors.toList());
        return this.nameMapper.toHierarchicalName(this.tagFormatter.formatName(id.getName()), formattedTags);
    }

    @Override
    protected Timer timer(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        return MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, this.withCommonTags(tags)), id -> new DropwizardTimer((MeterId)id, this.registry.timer(this.toDropwizardName((MeterId)id)), this.clock));
    }

    @Override
    protected DistributionSummary distributionSummary(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        return MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, this.withCommonTags(tags)), id -> new DropwizardDistributionSummary((MeterId)id, this.registry.histogram(this.toDropwizardName((MeterId)id))));
    }
}

