/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.ganglia;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ganglia.GangliaReporter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.IdentityTagFormatter;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.ganglia.GangliaConfig;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GangliaMeterRegistry
extends DropwizardMeterRegistry {
    private final GangliaReporter reporter;
    private final GangliaConfig config;

    public GangliaMeterRegistry() {
        this(System::getProperty);
    }

    public GangliaMeterRegistry(GangliaConfig config) {
        this(config, HierarchicalNameMapper.DEFAULT, Clock.SYSTEM);
    }

    public GangliaMeterRegistry(GangliaConfig config, HierarchicalNameMapper nameMapper, Clock clock) {
        super(nameMapper, clock, new IdentityTagFormatter());
        this.config = config;
        try {
            GMetric ganglia = new GMetric(config.host(), config.port(), config.addressingMode(), config.ttl());
            this.reporter = GangliaReporter.forRegistry((MetricRegistry)this.getDropwizardRegistry()).convertRatesTo(config.rateUnits()).convertDurationsTo(config.durationUnits()).build(ganglia);
            this.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to configure Ganglia metrics reporting", e);
        }
    }

    public void stop() {
        this.reporter.stop();
    }

    public void start() {
        this.reporter.start(this.config.step().getSeconds(), TimeUnit.SECONDS);
    }
}

