/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.graphite;

import io.micrometer.core.instrument.TagFormatter;
import java.text.Normalizer;
import java.util.regex.Pattern;

public class GraphiteTagFormatter
implements TagFormatter {
    private static final Pattern blacklistedChars = Pattern.compile("[{}(),=\\[\\]/]");

    @Override
    public String formatName(String name) {
        return this.format(name);
    }

    @Override
    public String formatTagKey(String key) {
        return this.format(key);
    }

    @Override
    public String formatTagValue(String value) {
        return this.format(value);
    }

    private String format(String name) {
        String sanitized = Normalizer.normalize(name, Normalizer.Form.NFKD);
        return blacklistedChars.matcher(sanitized).replaceAll("_");
    }
}

