/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.prometheus;

import io.micrometer.core.instrument.TagFormatter;
import java.util.regex.Pattern;

public class PrometheusTagFormatter
implements TagFormatter {
    private static final Pattern nameChars = Pattern.compile("[^a-zA-Z0-9_:]");
    private static final Pattern tagKeyChars = Pattern.compile("[^a-zA-Z0-9_]");

    @Override
    public String formatName(String name) {
        String sanitized = nameChars.matcher(name).replaceAll("_");
        if (!Character.isLetter(sanitized.charAt(0))) {
            sanitized = "m_" + sanitized;
        }
        return sanitized;
    }

    @Override
    public String formatTagKey(String key) {
        String sanitized = tagKeyChars.matcher(key).replaceAll("_");
        if (!Character.isLetter(sanitized.charAt(0))) {
            sanitized = "m_" + sanitized;
        }
        return sanitized;
    }

    @Override
    public String formatTagValue(String value) {
        return value;
    }
}

