/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.simple.AbstractSimpleMeter;
import io.micrometer.core.instrument.simple.SimpleUtils;
import io.micrometer.core.instrument.util.MeterId;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.function.ToDoubleFunction;

public class SimpleGauge<T>
extends AbstractSimpleMeter
implements Gauge {
    private static final Tag TYPE_TAG = SimpleUtils.typeTag(Meter.Type.Gauge);
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> value;
    private final MeterId gaugeId;

    public SimpleGauge(MeterId id, T obj, ToDoubleFunction<T> value) {
        super(id);
        this.ref = new WeakReference<T>(obj);
        this.value = value;
        this.gaugeId = id.withTags(TYPE_TAG);
    }

    @Override
    public double value() {
        return this.value.applyAsDouble(this.ref.get());
    }

    @Override
    public List<Measurement> measure() {
        return Collections.singletonList(this.gaugeId.measurement(this.value()));
    }
}

