/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import com.google.common.cache.Cache;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.CacheMetrics;
import io.micrometer.core.instrument.binder.ExecutorServiceMetrics;
import io.micrometer.core.instrument.internal.TimedExecutorService;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Meters {
    public static Builder build(String name) {
        return new Builder(name);
    }

    public static Cache monitor(MeterRegistry registry, Cache cache, String name, Tag ... tags) {
        new CacheMetrics(name, Arrays.asList(tags), cache).bindTo(registry);
        return cache;
    }

    public static Cache monitor(MeterRegistry registry, Cache cache, String name, Iterable<Tag> tags) {
        new CacheMetrics(name, tags, cache).bindTo(registry);
        return cache;
    }

    public static Executor monitor(MeterRegistry registry, Executor executor, String name, Iterable<Tag> tags) {
        Timer commandTimer = registry.timer(name, tags);
        return commandTimer::record;
    }

    public static Executor monitor(MeterRegistry registry, Executor executor, String name, Tag ... tags) {
        return Meters.monitor(registry, executor, name, Arrays.asList(tags));
    }

    public static ExecutorService monitor(MeterRegistry registry, ExecutorService executor, String name, Iterable<Tag> tags) {
        new ExecutorServiceMetrics(executor, name, tags).bindTo(registry);
        return new TimedExecutorService(registry, executor, name, tags);
    }

    public static ExecutorService monitor(MeterRegistry registry, ExecutorService executor, String name, Tag ... tags) {
        return Meters.monitor(registry, executor, name, Arrays.asList(tags));
    }

    public static boolean equals(Meter m1, Object o) {
        if (m1 == null && o != null) {
            return false;
        }
        if (o == null && m1 != null) {
            return false;
        }
        if (!(o instanceof Meter)) {
            return false;
        }
        if (m1 == o) {
            return true;
        }
        Meter m2 = (Meter)o;
        return (m1.getName() != null ? m1.getName().equals(m2.getName()) : m2.getName() == null) && (m1.getTags() != null ? m1.getTags().equals(m2.getTags()) : m2.getTags() == null) && (m1.getType() != null ? m1.getType().equals((Object)m2.getType()) : m2.getType() == null);
    }

    public static int hashCode(Meter m) {
        int result = m.getName() != null ? m.getName().hashCode() : 0;
        result = 31 * result + (m.getTags() != null ? m.getTags().hashCode() : 0);
        result = 31 * result + (m.getType() != null ? m.getType().hashCode() : 0);
        return result;
    }

    public static class Builder {
        private final String name;
        private Iterable<Tag> tags = Collections.emptyList();
        private Meter.Type type = Meter.Type.Other;

        Builder(String name) {
            this.name = name;
        }

        public Builder tags(Iterable<Tag> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(String ... tags) {
            this.tags = Tags.zip(tags);
            return this;
        }

        public Builder type(Meter.Type type) {
            this.type = type;
            return this;
        }

        public Meter create(final Function<String, List<Measurement>> measure) {
            return new Meter(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public Iterable<Tag> getTags() {
                    return tags;
                }

                @Override
                public Meter.Type getType() {
                    return type;
                }

                @Override
                public List<Measurement> measure() {
                    List measurements = (List)measure.apply(name);
                    measurements.forEach(m -> tags.forEach(t -> m.getTags().add((Tag)t)));
                    return measurements;
                }

                public boolean equals(Object o) {
                    return Meters.equals(this, o);
                }

                public int hashCode() {
                    return Meters.hashCode(this);
                }
            };
        }

        public <T> Meter create(final T obj, final BiFunction<String, T, List<Measurement>> measure) {
            return new Meter(){
                private WeakReference<T> ref;
                {
                    this.ref = new WeakReference<Object>(obj);
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public Iterable<Tag> getTags() {
                    return tags;
                }

                @Override
                public Meter.Type getType() {
                    return type;
                }

                @Override
                public List<Measurement> measure() {
                    if (this.ref.get() != null) {
                        List measurements = (List)measure.apply(name, this.ref.get());
                        measurements.forEach(m -> tags.forEach(t -> m.getTags().add((Tag)t)));
                        return measurements;
                    }
                    return Collections.emptyList();
                }

                public boolean equals(Object o) {
                    return Meters.equals(this, o);
                }

                public int hashCode() {
                    return Meters.hashCode(this);
                }
            };
        }
    }
}

