/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.atlas;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.atlas.AtlasConfig;
import com.netflix.spectator.atlas.AtlasRegistry;
import com.netflix.spectator.atlas.impl.MeasurementSerializer;
import com.netflix.spectator.atlas.impl.PublishPayload;
import com.netflix.spectator.impl.AsciiSet;
import com.netflix.spectator.sandbox.HttpClient;
import io.micrometer.core.instrument.spectator.SpectatorMeterRegistry;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasUtils {
    private static Logger logger = LoggerFactory.getLogger(AtlasUtils.class);

    public static AtlasConfig pushConfig(final String uri) {
        return new AtlasConfig(){

            public String uri() {
                return uri;
            }

            public boolean enabled() {
                return false;
            }

            public String get(String k) {
                return System.getProperty(k);
            }
        };
    }

    public static AtlasConfig pollingConfig(final String uri, final Duration step) {
        return new AtlasConfig(){

            public String uri() {
                return uri;
            }

            public Duration step() {
                return step;
            }

            public String get(String k) {
                return System.getProperty(k);
            }
        };
    }

    public static void atlasPublish(SpectatorMeterRegistry registry, AtlasConfig config) {
        AsciiSet charset = AsciiSet.fromPattern((String)config.validTagCharacters());
        Map<String, AsciiSet> overrides = config.validTagValueCharacters().keySet().stream().collect(Collectors.toMap(k -> k, AsciiSet::fromPattern));
        SimpleModule module = new SimpleModule().addSerializer(Measurement.class, (JsonSerializer)new MeasurementSerializer(charset, overrides));
        ObjectMapper smileMapper = new ObjectMapper((JsonFactory)new SmileFactory()).registerModule((Module)module);
        if (registry.getSpectatorRegistry() instanceof AtlasRegistry) {
            AtlasRegistry atlasRegistry = (AtlasRegistry)registry.getSpectatorRegistry();
            List ms = atlasRegistry.stream().flatMap(m -> StreamSupport.stream(m.measure().spliterator(), false)).collect(Collectors.toList());
            PublishPayload p = new PublishPayload(config.commonTags(), ms);
            try {
                HttpClient.DEFAULT.newRequest("spectator-reg-atlas", URI.create(config.uri())).withMethod("POST").withConnectTimeout((int)config.connectTimeout().toMillis()).withReadTimeout((int)config.readTimeout().toMillis()).withContent("application/x-jackson-smile", smileMapper.writeValueAsBytes((Object)p)).send();
            }
            catch (IOException e) {
                logger.error("Unable to publish Atlas metrics", (Throwable)e);
            }
        }
    }
}

