/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder;

import com.google.common.cache.Cache;
import com.google.common.cache.LoadingCache;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;

public class CacheMetrics
implements MeterBinder {
    private final String name;
    private final Iterable<Tag> tags;
    private final Cache<?, ?> cache;

    public CacheMetrics(String name, Iterable<Tag> tags, Cache<?, ?> cache) {
        this.name = name;
        this.tags = tags;
        this.cache = cache;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        registry.gauge(this.name + "_size", this.tags, this.cache, Cache::size);
        registry.counter(this.name + "_requests", Tags.zip("result", "miss"), this.cache, c -> c.stats().missCount());
        registry.counter(this.name + "_requests", Tags.zip("result", "hit"), this.cache, c -> c.stats().hitCount());
        registry.counter(this.name + "_evictions", this.tags, this.cache, c -> c.stats().evictionCount());
        if (this.cache instanceof LoadingCache) {
            registry.counter(this.name + "_load_duration", this.tags, this.cache, c -> c.stats().totalLoadTime());
            registry.counter(this.name + "_loads", this.tags, this.cache, c -> c.stats().loadCount());
            registry.counter(this.name + "_load_failures", this.tags, this.cache, c -> c.stats().loadExceptionCount());
        }
    }
}

