/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.influx;

import io.micrometer.core.instrument.TagFormatter;

public class InfluxTagFormatter
implements TagFormatter {
    @Override
    public String formatName(String name) {
        return this.format(name.replace("=", "_"));
    }

    @Override
    public String formatTagKey(String key) {
        if (key.equals("time")) {
            throw new IllegalArgumentException("'time' is an invalid tag key in InfluxDB");
        }
        return this.format(key);
    }

    @Override
    public String formatTagValue(String value) {
        if (value.equals("time")) {
            throw new IllegalArgumentException("'time' is an invalid tag value in InfluxDB");
        }
        return this.format(value);
    }

    private String format(String name) {
        return name.replace(",", "\\,").replace(" ", "\\ ").replace("=", "\\=").replace("\"", "\\\"");
    }
}

