/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.AbstractMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.internal.FunctionTrackingCounter;
import io.micrometer.core.instrument.simple.SimpleCounter;
import io.micrometer.core.instrument.simple.SimpleDistributionSummary;
import io.micrometer.core.instrument.simple.SimpleGauge;
import io.micrometer.core.instrument.simple.SimpleLongTaskTimer;
import io.micrometer.core.instrument.simple.SimpleTimer;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.MapAccess;
import io.micrometer.core.instrument.util.MeterId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ToDoubleFunction;

public class SimpleMeterRegistry
extends AbstractMeterRegistry {
    private final ConcurrentMap<MeterId, Meter> meterMap = new ConcurrentHashMap<MeterId, Meter>();

    public SimpleMeterRegistry() {
        this(Clock.SYSTEM);
    }

    public SimpleMeterRegistry(Clock clock) {
        super(clock);
    }

    @Override
    public Counter counter(String name, Iterable<Tag> tags) {
        return MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, this.withCommonTags(tags)), SimpleCounter::new);
    }

    @Override
    public <T> T counter(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, this.withCommonTags(tags)), id -> new FunctionTrackingCounter<Object>((MeterId)id, obj, f));
        return obj;
    }

    @Override
    public DistributionSummary distributionSummary(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        this.registerQuantilesGaugeIfNecessary(name, tags, quantiles);
        return MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, this.withCommonTags(tags)), SimpleDistributionSummary::new);
    }

    @Override
    protected Timer timer(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        this.registerQuantilesGaugeIfNecessary(name, tags, quantiles);
        return MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, this.withCommonTags(tags)), id -> new SimpleTimer((MeterId)id, this.getClock()));
    }

    private void registerQuantilesGaugeIfNecessary(String name, Iterable<Tag> tags, Quantiles quantiles) {
        if (quantiles != null) {
            for (Double q : quantiles.monitored()) {
                LinkedList<Tag> quantileTags = new LinkedList<Tag>();
                tags.forEach(quantileTags::add);
                quantileTags.add(Tag.of("quantile", Double.isNaN(q) ? "NaN" : Double.toString(q)));
                MapAccess.computeIfAbsent(this.meterMap, new MeterId(name + ".quantiles", quantileTags), id -> new SimpleGauge<Double>((MeterId)id, q, quantiles::get));
            }
        }
    }

    @Override
    public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
        return MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, this.withCommonTags(tags)), id -> new SimpleLongTaskTimer((MeterId)id, this.getClock()));
    }

    @Override
    public MeterRegistry register(Meter meter) {
        this.meterMap.put(new MeterId(meter.getName(), meter.getTags()), meter);
        return this;
    }

    @Override
    public <T> T gauge(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, this.withCommonTags(tags)), id -> new SimpleGauge<Object>((MeterId)id, obj, f));
        return obj;
    }

    @Override
    public Collection<Meter> getMeters() {
        return this.meterMap.values();
    }

    @Override
    public <M extends Meter> Optional<M> findMeter(Class<M> mClass, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.keySet().stream().filter(id -> id.getName().equals(name)).filter(id -> id.getTags().containsAll(tagsToMatch)).findAny().map(this.meterMap::get).filter(mClass::isInstance).map(mClass::cast);
    }

    @Override
    public Optional<Meter> findMeter(Meter.Type type, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.keySet().stream().filter(id -> id.getName().equals(name)).filter(id -> id.getTags().containsAll(tagsToMatch)).findAny().map(this.meterMap::get).filter(m -> m.getType().equals((Object)type));
    }

    public void clear() {
        this.meterMap.clear();
    }
}

