/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.simple.SimpleUtils;
import io.micrometer.core.instrument.util.MeterId;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class SimpleTimer
extends AbstractTimer {
    private static final Tag STAT_COUNT_TAG = Tag.of("statistic", "count");
    private static final Tag STAT_AMOUNT_TAG = Tag.of("statistic", "amount");
    private static final Tag TYPE_TAG = SimpleUtils.typeTag(Meter.Type.Timer);
    private final MeterId countId;
    private final MeterId amountId;
    private LongAdder count = new LongAdder();
    private LongAdder totalTime = new LongAdder();

    public SimpleTimer(MeterId id, Clock clock) {
        super(id, clock);
        this.countId = id.withTags(TYPE_TAG, STAT_COUNT_TAG);
        this.amountId = id.withTags(TYPE_TAG, STAT_AMOUNT_TAG);
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.count.increment();
            this.totalTime.add(TimeUnit.NANOSECONDS.convert(amount, unit));
        }
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.totalTime.doubleValue(), unit);
    }

    @Override
    public List<Measurement> measure() {
        return Arrays.asList(this.countId.measurement(this.count()), this.amountId.measurement(this.totalTime(TimeUnit.NANOSECONDS)));
    }
}

