/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator;

import com.netflix.spectator.api.AbstractMeter;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import io.micrometer.core.instrument.AbstractMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TagFormatter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.spectator.CustomSpectatorToDoubleGauge;
import io.micrometer.core.instrument.spectator.SpectatorCounter;
import io.micrometer.core.instrument.spectator.SpectatorDistributionSummary;
import io.micrometer.core.instrument.spectator.SpectatorGauge;
import io.micrometer.core.instrument.spectator.SpectatorLongTaskTimer;
import io.micrometer.core.instrument.spectator.SpectatorMeterWrapper;
import io.micrometer.core.instrument.spectator.SpectatorTimer;
import io.micrometer.core.instrument.spectator.SpectatorUtils;
import io.micrometer.core.instrument.spectator.step.FunctionTrackingStepCounter;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToDoubleFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class SpectatorMeterRegistry
extends AbstractMeterRegistry {
    private final TagFormatter tagFormatter;
    private final Registry registry;
    protected final Map<com.netflix.spectator.api.Meter, Meter> meterMap = new HashMap<com.netflix.spectator.api.Meter, Meter>();

    public SpectatorMeterRegistry(Registry registry, Clock clock, TagFormatter tagFormatter) {
        super(clock);
        this.registry = registry;
        this.tagFormatter = tagFormatter;
    }

    private Collection<com.netflix.spectator.api.Tag> toSpectatorTags(Iterable<Tag> tags) {
        return Stream.concat(this.commonTags.stream(), StreamSupport.stream(tags.spliterator(), false)).map(t -> new BasicTag(this.tagFormatter.formatTagKey(t.getKey()), this.tagFormatter.formatTagValue(t.getValue()))).collect(Collectors.toList());
    }

    @Override
    public Collection<Meter> getMeters() {
        return this.meterMap.values();
    }

    @Override
    public <M extends Meter> Optional<M> findMeter(Class<M> mClass, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.entrySet().stream().filter(e -> mClass.isInstance(e.getValue())).filter(e -> ((com.netflix.spectator.api.Meter)e.getKey()).id().name().equals(name)).filter(e -> StreamSupport.stream(((com.netflix.spectator.api.Meter)e.getKey()).id().tags().spliterator(), false).map(t -> new ImmutableTag(t.key(), t.value())).collect(Collectors.toList()).containsAll(tagsToMatch)).map(Map.Entry::getValue).findAny().filter(mClass::isInstance).map(mClass::cast);
    }

    @Override
    public Optional<Meter> findMeter(Meter.Type type, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.entrySet().stream().filter(e -> ((Meter)e.getValue()).getType().equals((Object)type)).filter(e -> ((com.netflix.spectator.api.Meter)e.getKey()).id().name().equals(name)).filter(e -> StreamSupport.stream(((com.netflix.spectator.api.Meter)e.getKey()).id().tags().spliterator(), false).map(t -> new ImmutableTag(t.key(), t.value())).collect(Collectors.toList()).containsAll(tagsToMatch)).map(Map.Entry::getValue).findAny();
    }

    @Override
    public Counter counter(String name, Iterable<Tag> tags) {
        com.netflix.spectator.api.Counter counter = this.registry.counter(this.tagFormatter.formatName(name), this.toSpectatorTags(tags));
        return (Counter)this.meterMap.computeIfAbsent((com.netflix.spectator.api.Meter)counter, c -> new SpectatorCounter(counter));
    }

    protected com.netflix.spectator.api.Counter newCounter(String name, Iterable<Tag> tags) {
        try {
            Id id = SpectatorUtils.spectatorId(this.registry, name, tags);
            Method newCounter = this.registry.getClass().getDeclaredMethod("newCounter", Id.class);
            newCounter.setAccessible(true);
            return (com.netflix.spectator.api.Counter)newCounter.invoke((Object)this.registry, id);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Provide a way to construct a new counter that is not yet registered.");
        }
    }

    @Override
    public DistributionSummary distributionSummary(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        this.registerQuantilesGaugeIfNecessary(name, tags, quantiles, UnaryOperator.identity());
        com.netflix.spectator.api.DistributionSummary ds = this.registry.distributionSummary(this.tagFormatter.formatName(name), this.toSpectatorTags(tags));
        return (DistributionSummary)this.meterMap.computeIfAbsent((com.netflix.spectator.api.Meter)ds, d -> new SpectatorDistributionSummary(ds));
    }

    @Override
    protected Timer timer(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        this.registerQuantilesGaugeIfNecessary(name, tags, quantiles, t -> t / 1000000.0);
        this.registerHistogramCounterIfNecessary(name, tags, histogram);
        com.netflix.spectator.api.Timer timer = this.registry.timer(this.tagFormatter.formatName(name), this.toSpectatorTags(tags));
        return (Timer)this.meterMap.computeIfAbsent((com.netflix.spectator.api.Meter)timer, t -> new SpectatorTimer(timer, quantiles, this.getClock()));
    }

    private void registerHistogramCounterIfNecessary(String name, Iterable<Tag> tags, Histogram<?> histogram) {
    }

    private void registerQuantilesGaugeIfNecessary(String name, Iterable<Tag> tags, Quantiles quantiles, UnaryOperator<Double> scaling) {
        if (quantiles != null) {
            for (Double q : quantiles.monitored()) {
                LinkedList<com.netflix.spectator.api.Tag> quantileTags = new LinkedList<com.netflix.spectator.api.Tag>(this.toSpectatorTags(tags));
                if (Double.isNaN(q)) continue;
                quantileTags.add((com.netflix.spectator.api.Tag)new BasicTag("quantile", Double.toString(q)));
                quantileTags.add((com.netflix.spectator.api.Tag)new BasicTag("statistic", "value"));
                this.registry.gauge(this.registry.createId(this.tagFormatter.formatName(name), quantileTags), (Object)q, q2 -> (Double)scaling.apply(quantiles.get((double)q2)));
            }
        }
    }

    @Override
    public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
        com.netflix.spectator.api.LongTaskTimer timer = this.registry.longTaskTimer(this.tagFormatter.formatName(name), this.toSpectatorTags(tags));
        return (LongTaskTimer)this.meterMap.computeIfAbsent((com.netflix.spectator.api.Meter)timer, t -> new SpectatorLongTaskTimer(timer));
    }

    @Override
    public MeterRegistry register(Meter meter) {
        Id id = SpectatorUtils.spectatorId(this.registry, meter.getName(), meter.getTags());
        if (this.registry.get(id) == null) {
            AbstractMeter<Meter> spectatorMeter = new AbstractMeter<Meter>(this.registry.clock(), id, meter){

                public Iterable<Measurement> measure() {
                    Meter meter = (Meter)this.ref.get();
                    if (meter != null) {
                        return meter.measure().stream().map(m -> {
                            Iterable formattedTags = m.getTags().stream().map(t -> Tag.of(SpectatorMeterRegistry.this.tagFormatter.formatTagKey(t.getKey()), SpectatorMeterRegistry.this.tagFormatter.formatTagValue(t.getValue()))).collect(Collectors.toList());
                            return new Measurement(SpectatorUtils.spectatorId(SpectatorMeterRegistry.this.registry, SpectatorMeterRegistry.this.tagFormatter.formatName(m.getName()), formattedTags), this.clock.wallTime(), m.getValue());
                        }).collect(Collectors.toList());
                    }
                    return Collections.emptyList();
                }
            };
            this.meterMap.put((com.netflix.spectator.api.Meter)spectatorMeter, meter);
        }
        return this;
    }

    @Override
    public <T> T gauge(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        Id gaugeId = this.registry.createId(this.tagFormatter.formatName(name), this.toSpectatorTags(tags));
        CustomSpectatorToDoubleGauge gauge = new CustomSpectatorToDoubleGauge(this.registry.clock(), gaugeId, obj, f);
        this.registry.register(gauge);
        this.meterMap.computeIfAbsent((com.netflix.spectator.api.Meter)gauge, g -> new SpectatorGauge(gauge));
        return obj;
    }

    public Registry getSpectatorRegistry() {
        return this.registry;
    }

    protected <T> T stepCounter(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f, long stepMillis) {
        Id id = SpectatorUtils.spectatorId(this.getSpectatorRegistry(), name, tags);
        FunctionTrackingStepCounter heisenCounter = new FunctionTrackingStepCounter(id, this.getSpectatorRegistry().clock(), stepMillis, obj, f);
        this.meterMap.computeIfAbsent((com.netflix.spectator.api.Meter)heisenCounter, c -> {
            this.registry.register((com.netflix.spectator.api.Meter)heisenCounter);
            return new SpectatorMeterWrapper(name, tags, Meter.Type.Counter, (com.netflix.spectator.api.Meter)c);
        });
        return obj;
    }
}

