/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator;

import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Timer;
import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.spectator.SpectatorUtils;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.MeterId;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SpectatorTimer
extends AbstractTimer {
    private final Timer timer;
    private final Quantiles quantiles;

    SpectatorTimer(Timer timer, Quantiles quantiles, Clock clock) {
        super(new MeterId(timer.id().name(), SpectatorUtils.tags((Meter)timer)), clock);
        this.timer = timer;
        this.quantiles = quantiles;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        long nanoAmount = unit.toNanos(amount);
        this.timer.record(nanoAmount, TimeUnit.NANOSECONDS);
        if (this.quantiles != null) {
            this.quantiles.observe(nanoAmount);
        }
    }

    @Override
    public long count() {
        return this.timer.count();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.timer.totalTime(), unit);
    }

    @Override
    public List<Measurement> measure() {
        return SpectatorUtils.measurements((Meter)this.timer);
    }
}

