/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Tag;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SpectatorUtils {
    public static List<Measurement> measurements(Meter meter) {
        return StreamSupport.stream(meter.measure().spliterator(), false).map(m -> new Measurement(m.id().name(), StreamSupport.stream(m.id().tags().spliterator(), false).map(t -> Tag.of(t.key(), t.value())).collect(Collectors.toList()), m.value())).collect(Collectors.toList());
    }

    public static List<Tag> tags(Meter meter) {
        return StreamSupport.stream(meter.id().tags().spliterator(), false).map(t -> Tag.of(t.key(), t.value())).collect(Collectors.toList());
    }

    public static Id spectatorId(Registry registry, String name, Iterable<Tag> tags) {
        String[] flattenedTags = (String[])StreamSupport.stream(tags.spliterator(), false).flatMap(t -> Stream.of(t.getKey(), t.getValue())).toArray(String[]::new);
        return registry.createId(name, flattenedTags);
    }

    public static com.netflix.spectator.api.Clock spectatorClock(final Clock clock) {
        return new com.netflix.spectator.api.Clock(){

            public long wallTime() {
                return clock.wallTime();
            }

            public long monotonicTime() {
                return clock.monotonicTime();
            }
        };
    }
}

