/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator.step;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.impl.StepValue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.function.ToDoubleFunction;

public class FunctionTrackingStepCounter<T>
implements Counter {
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> f;
    private final AtomicLong lastCount = new AtomicLong(0L);
    private final StepDouble value;
    private final Id id;

    public FunctionTrackingStepCounter(Id id, Clock clock, long step, T obj, ToDoubleFunction<T> f) {
        this.id = id;
        this.value = new StepDouble(clock, step);
        this.ref = new WeakReference<T>(obj);
        this.f = f;
    }

    public void increment() {
        throw new UnsupportedOperationException("Should never be called directly");
    }

    public void increment(long amount) {
        throw new UnsupportedOperationException("Should never be called directly.");
    }

    public long count() {
        this.pollFunction();
        return (long)this.value.poll();
    }

    private void pollFunction() {
        Object t = this.ref.get();
        if (t != null) {
            long absoluteCount = (long)this.f.applyAsDouble(t);
            long inc = Math.max(0L, absoluteCount - this.lastCount.get());
            this.lastCount.addAndGet(inc);
            this.value.getCurrent().add(inc);
        }
    }

    public Id id() {
        return this.id;
    }

    public Iterable<Measurement> measure() {
        this.pollFunction();
        double rate = this.value.pollAsRate();
        Measurement m = new Measurement(this.id, this.value.timestamp(), rate);
        return Collections.singletonList(m);
    }

    public boolean hasExpired() {
        return this.ref.get() != null;
    }

    private class StepDouble
    implements StepValue {
        private final Clock clock;
        private final long step;
        private volatile double previous = 0.0;
        private final DoubleAdder current = new DoubleAdder();
        private final AtomicLong lastInitPos;

        StepDouble(Clock clock, long step) {
            this.clock = clock;
            this.step = step;
            this.lastInitPos = new AtomicLong(clock.wallTime() / step);
        }

        private void rollCount(long now) {
            long stepTime = now / this.step;
            long lastInit = this.lastInitPos.get();
            if (lastInit < stepTime && this.lastInitPos.compareAndSet(lastInit, stepTime)) {
                double v = this.current.sumThenReset();
                this.previous = lastInit == stepTime - 1L ? v : 0.0;
            }
        }

        public DoubleAdder getCurrent() {
            return this.current;
        }

        double poll() {
            this.rollCount(this.clock.wallTime());
            return this.previous;
        }

        public double pollAsRate() {
            double amount = this.poll();
            double period = (double)this.step / 1000.0;
            return amount / period;
        }

        public long timestamp() {
            return this.lastInitPos.get() * this.step;
        }
    }
}

