/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.util;

import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;

public class HierarchicalNameMapper {
    public static final HierarchicalNameMapper DEFAULT = new HierarchicalNameMapper();
    protected String tagSeparator = ".";
    protected String valueSeparator = ".";
    protected Comparator<Tag> tagComparator = Comparator.comparing(Tag::getKey);

    public HierarchicalNameMapper setTagSeparator(String tagSeparator) {
        this.tagSeparator = tagSeparator;
        return this;
    }

    public HierarchicalNameMapper setValueSeparator(String valueSeparator) {
        this.valueSeparator = valueSeparator;
        return this;
    }

    public HierarchicalNameMapper setTagComparator(Comparator<Tag> tagComparator) {
        this.tagComparator = tagComparator;
        return this;
    }

    public String toHierarchicalName(String name, Collection<Tag> tags) {
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags);
        tagsCopy.sort(this.tagComparator);
        return name + this.tagSeparator + tagsCopy.stream().map(t -> t.getKey() + this.valueSeparator + t.getValue()).collect(Collectors.joining(this.tagSeparator));
    }
}

