/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.atlas;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.atlas.AtlasConfig;
import com.netflix.spectator.atlas.AtlasRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.IdentityTagFormatter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.spectator.SpectatorMeterRegistry;
import java.util.function.ToDoubleFunction;

public class AtlasMeterRegistry
extends SpectatorMeterRegistry {
    private final long stepMillis;

    public AtlasMeterRegistry(AtlasConfig config, final Clock clock) {
        super((Registry)new AtlasRegistry(new com.netflix.spectator.api.Clock(){

            public long wallTime() {
                return clock.wallTime();
            }

            public long monotonicTime() {
                return clock.monotonicTime();
            }
        }, config), clock, new IdentityTagFormatter());
        this.stepMillis = config.step().toMillis();
        this.start();
    }

    public AtlasMeterRegistry(AtlasConfig config) {
        this(config, Clock.SYSTEM);
    }

    public void start() {
        this.getAtlasRegistry().start();
    }

    public void stop() {
        this.getAtlasRegistry().stop();
    }

    private AtlasRegistry getAtlasRegistry() {
        return (AtlasRegistry)this.getSpectatorRegistry();
    }

    @Override
    public <T> T counter(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        return this.stepCounter(name, tags, obj, f, this.stepMillis);
    }
}

