/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.datadog;

import com.netflix.spectator.api.Registry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.datadog.DatadogConfig;
import io.micrometer.core.instrument.datadog.DatadogRegistry;
import io.micrometer.core.instrument.datadog.DatadogTagFormatter;
import io.micrometer.core.instrument.spectator.SpectatorMeterRegistry;
import java.util.function.ToDoubleFunction;

public class DatadogMeterRegistry
extends SpectatorMeterRegistry {
    private final long stepMillis;

    public DatadogMeterRegistry(DatadogConfig config, final Clock clock) {
        super((Registry)new DatadogRegistry(config, new com.netflix.spectator.api.Clock(){

            public long wallTime() {
                return clock.wallTime();
            }

            public long monotonicTime() {
                return clock.monotonicTime();
            }
        }), clock, new DatadogTagFormatter());
        this.stepMillis = config.step().toMillis();
        ((DatadogRegistry)this.getSpectatorRegistry()).start();
    }

    public DatadogMeterRegistry(DatadogConfig config) {
        this(config, Clock.SYSTEM);
    }

    @Override
    public <T> T counter(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        return this.stepCounter(name, tags, obj, f, this.stepMillis);
    }
}

