/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Timer;
import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.util.MeterId;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class DropwizardTimer
extends AbstractTimer {
    private final Timer impl;
    private final AtomicLong totalTime = new AtomicLong(0L);

    public DropwizardTimer(MeterId id, Timer impl, Clock clock) {
        super(id, clock);
        this.id = id;
        this.impl = impl;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.impl.update(amount, unit);
            this.totalTime.addAndGet(TimeUnit.NANOSECONDS.convert(amount, unit));
        }
    }

    @Override
    public long count() {
        return this.impl.getCount();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.convert(this.totalTime.get(), TimeUnit.NANOSECONDS, unit);
    }

    @Override
    public List<Measurement> measure() {
        return Collections.singletonList(this.id.measurement(this.impl.getMeanRate()));
    }
}

