/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.influx;

import com.netflix.spectator.api.Registry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.IdentityTagFormatter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.influx.InfluxConfig;
import io.micrometer.core.instrument.influx.InfluxRegistry;
import io.micrometer.core.instrument.spectator.SpectatorMeterRegistry;
import java.util.function.ToDoubleFunction;

public class InfluxMeterRegistry
extends SpectatorMeterRegistry {
    private final long stepMillis;

    public InfluxMeterRegistry(InfluxConfig config, final Clock clock) {
        super((Registry)new InfluxRegistry(config, new com.netflix.spectator.api.Clock(){

            public long wallTime() {
                return clock.wallTime();
            }

            public long monotonicTime() {
                return clock.monotonicTime();
            }
        }), clock, new IdentityTagFormatter());
        this.stepMillis = config.step().toMillis();
        ((InfluxRegistry)this.getSpectatorRegistry()).start();
    }

    public InfluxMeterRegistry(InfluxConfig config) {
        this(config, Clock.SYSTEM);
    }

    @Override
    public <T> T counter(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        return this.stepCounter(name, tags, obj, f, this.stepMillis);
    }
}

