/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.internal;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.util.MeterId;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.function.ToDoubleFunction;

public class FunctionTrackingCounter<T>
implements Meter {
    private final MeterId id;
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> f;

    public FunctionTrackingCounter(MeterId id, T obj, ToDoubleFunction<T> f) {
        this.id = id;
        this.ref = new WeakReference<T>(obj);
        this.f = f;
    }

    @Override
    public String getName() {
        return this.id.getName();
    }

    @Override
    public Iterable<Tag> getTags() {
        return this.id.getTags();
    }

    @Override
    public Meter.Type getType() {
        return Meter.Type.Counter;
    }

    @Override
    public List<Measurement> measure() {
        Object obj = this.ref.get();
        return obj != null ? Collections.singletonList(this.id.measurement(this.f.applyAsDouble(obj))) : Collections.emptyList();
    }
}

